/*----------------------------------------------------------------------------
 * Name     : main.c
 * Purpose  : EPD21 Verify Kit
 * Note(s)  :
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include		<math.h>
#include    "main.h"
#include    "timer.h"
#include    "lcm.h"
#include    "led.h"
#include    "button.h"
#include		"bleprocess.h"
#include		"bc7701.h"
#include		"hci.h"
#include		"service.h"

// <<< Use Configuration Wizard in Context Menu >>>

//	<e> Change Connect Interval Enable
#define	_CHG_CNNT_INTV_ENABLE_   (1)
//		<o> Connect Interval(ms)<10-80000>
#define 	_CHG_CNNT_INTV_VALUE_  (30)
//	</e>

//	<e> MCU sleep mode Enable/disable
#define	_MCU_SLEEP_ENABLE_  (1)
//		<o> Enter deep sleep delay timer(ms)<10-5000>
#define 	_SLEEP_DELAY_TIMER_  (500)
//	</e>

//	<h> WakeUp Signal Configure
//		<o> Wake up Signal Width(byte)<1-8>
#define 	_MASTER_WUW_VALUE_  (2)
//		<o> Wake up Signal delay time(ms)<0-20>
#define 	_MASTER_WUT_VALUE_  (8)
//	</h>



union
{
	u16	U;
	struct
	{
		u16	ButtonChange: 1;
		u16	BLE_ConnectState: 1;
		u16	BLE_PwrOnDisplay: 1;
		u16	BLE_ConnectDisplay: 1;
		u16	BLE_NotWakeUp:1;
		u16	BLE_WakeUpDelay:1;
		u16	BLE_ServiceMsg:1;
	   u16	BLE_WaitEventRsp:1;
		u16	BLE_ReadCnntIntv:1;
		u16	BLE_WakeUpSignal:1;
      u16:4;
		u16	MCU_EnterSleep:1;
		u16	BLE_TestMode:1;
	}B;
}MFlag;

u32   time_period;
u8		key_status;
u8		test_key;

u8		DataPayload[PACKAGE_MAX_SIZE];
bool	LEDStatusUpdate;
u8		BLEWakeUpDlyTm;
bool	BLESleepMode;
u16	BLESleepDlyTm;
tSTATUS	BLE_StatusEvent;

#define	MESS_QUEUE_MAX			16
tBCI_PACKAGE	*TxMsgQueue[MESS_QUEUE_MAX];
u8		uTxMsgQueueW,uTxMsgQueueR;
#define IS_TXMQUEUE_FULL(LEN)		(((uTxMsgQueueW + LEN) >= MESS_QUEUE_MAX) ? ((uTxMsgQueueW + LEN - MESS_QUEUE_MAX) == uTxMsgQueueR) : ((uTxMsgQueueW + LEN) == uTxMsgQueueR))
#define IS_TXMQUEUE_EMPTY()      (uTxMsgQueueW == uTxMsgQueueR)
tBCI_PACKAGE	*MessageEvent = NULL;

#define	EVENT_RSP_ERR_MAX		8
u8		BLE_EventRspTOCnt;

tPROPERTIES		ServiceProperties;
tKEY_MESSAGE	Hmessage,Dmessage;
u16	ConnectIntervalTime;

u32	SerialNumber;
u32	SerialLoss;
u8		DummyWakeUpStep;

uc8	TestMessage[]=
{
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F',
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F',
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F',
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F',
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F',
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F',
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F',
	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
};

tBPS_MEAS BloodPressureMeas;
tWSS_MEAS WeightScaleMeas;

#define	SLEEP_DELAY_EN		0


#define		MDEBIO_ENABLE		1
#if	(MDEBIO_ENABLE == 1)

#define	MDBIO_P0_PORT				HT_GPIOC
#define	MDBIO_P0						GPIO_PIN_1
#define	MDBIO_P0_AFIO_PORT		GPIO_PC
#define	MDBIO_P0_AFIO_FUN			AFIO_FUN_GPIO

#define	MDBIO_P0_SET()				(MDBIO_P0_PORT->SRR = MDBIO_P0)
#define	MDBIO_P0_CLR()				(MDBIO_P0_PORT->RR = MDBIO_P0)
#define	MDBIO_P0_TOGGLE()			((MDBIO_P0_PORT->DOUTR & MDBIO_P0) ? MDBIO_P0_CLR():MDBIO_P0_SET())

#define	MDBIO_P1_PORT				HT_GPIOC
#define	MDBIO_P1						GPIO_PIN_2
#define	MDBIO_P1_AFIO_PORT		GPIO_PC
#define	MDBIO_P1_AFIO_FUN			AFIO_FUN_GPIO

#define	MDBIO_P1_SET()				(MDBIO_P1_PORT->SRR = MDBIO_P1)
#define	MDBIO_P1_CLR()				(MDBIO_P1_PORT->RR = MDBIO_P1)
#define	MDBIO_P1_TOGGLE()			((MDBIO_P1_PORT->DOUTR & MDBIO_P1) ? MDBIO_P1_CLR():MDBIO_P1_SET())

#endif


/*------------------------------------------------------------------------------
* Function Name : BLE process
* Description   :
* Input         :
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void TxMessageQueueJoin(void *pack)
{
	if(pack != NULL)
	{
		if(!IS_TXMQUEUE_FULL(1))
		{
			TxMsgQueue[uTxMsgQueueW] = pack;
			if(++uTxMsgQueueW >= MESS_QUEUE_MAX) uTxMsgQueueW = 0;
		}
		else free(pack);
	}
}
/*----------------------------------------------------------------------------
  Main Program
 *----------------------------------------------------------------------------*/
int main (void)
{
	tBCI_PACKAGE *evtpkg;

   CKCU_Configuration();
   MCU_gpio_Configuration();
   /* -------------- LCM initial ------------------------------------ */
   lcm_bus_configure();
   lcm_configure();
	lcm_put_map((u8 *)BestComm_Logo);
   lcm_put8x16_string((sc8 *)"BC7701",0,10,DSP_NORMAL);
   lcm_put8x16_string((sc8 *)"DevKit",1,10,DSP_NORMAL);
   lcm_put8x16_string((sc8 *)"Ver1.0",2,10,DSP_NORMAL);
   lcm_put6x8_string((sc8 *)"22/04/26",6,13,DSP_NORMAL);
   /* -------------- LED/Button IO initial -------------------------- */
   LED_IO_configure();
   BTN_IOConfigure();
	SystickConfigure();
#if (_RETARGET == 1)
	RETARGET_Configuration();
#endif
	BLE_ParameterInitial();
   delay_ms(1000);                      	/* delay 1s */
   lcm_clear();
   lcm_put8x8_string((s8 *)"BLE PwrOn :     ",0,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"BLE Connet: No  ",1,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"Host KEY 1: Up  ",2,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"Host KEY 2: Up  ",3,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"Host KEY 3: Up  ",4,0,DSP_NORMAL);
	timer_operate.bits.t1ms = FALSE;
	time_period	= 0;
   LED_always_on(LEDP);
   while(1)
   {
		if(timer_operate.bits.t1ms)
		{
         timer_operate.bits.t1ms = FALSE;
			MFlag.B.ButtonChange = BTN_ScanButtonStatus();
			BLE_TimerProcess();
			LED_flash_process();
			if(time_period) time_period--;
			if(BLEWakeUpDlyTm) BLEWakeUpDlyTm--;
			if(BLESleepDlyTm) BLESleepDlyTm--;
      }
		evtpkg = BLE_Process();
		if(BLE_Operate.States == _BLE_PWR_ON_SUCCESS_)
		{
			if(!MFlag.B.BLE_PwrOnDisplay)
			{
				lcm_put8x8_string((s8 *)"BLE PwrOn : OK  ",0,0,DSP_NORMAL);
				lcm_printf(7,0,DSP_NORMAL,LCM_FONT8X8,"BDA=%02X%02X%02X%02X%02X%02X",
								BLE_Operate.BDAddr.adr[5],
								BLE_Operate.BDAddr.adr[4],
								BLE_Operate.BDAddr.adr[3],
								BLE_Operate.BDAddr.adr[2],
								BLE_Operate.BDAddr.adr[1],
								BLE_Operate.BDAddr.adr[0]);
				MFlag.B.BLE_PwrOnDisplay = TRUE;
				BLESleepMode = FALSE;
				BLESleepDlyTm = _SLEEP_DELAY_TIMER_;
				MFlag.B.BLE_WaitEventRsp = FALSE;
			}
			//event package process
			if(evtpkg != NULL)
			{
				if(evtpkg->type == BCI_EVENT_PKG)
				{
					if((evtpkg->flag & EVTS_CODE_MASK) == EVTS_TIME_OUT)
					{
						BLE_EventRspTOCnt++;
					}
					else	BLE_EventRspTOCnt = 0;

					// command event response message
					if(evtpkg->opcode < GenericAccess)
					{
						switch(evtpkg->opcode)
						{
							case BCI_OPERATE_MODE:
								if((evtpkg->flag & EVTS_CODE_MASK) == EVTS_SUCCESS)
								{
									BLESleepMode = TRUE;
#if (_MCU_SLEEP_ENABLE_ == 1)
									MFlag.B.MCU_EnterSleep = TRUE;
#endif									
								}
								MFlag.B.BLE_WaitEventRsp = FALSE;
								break;
							case BCI_STATUS:
								memcpy((void *)&BLE_StatusEvent,evtpkg->param,sizeof(tSTATUS));
								if(BLE_StatusEvent.b.Connect) MFlag.B.BLE_ConnectState = TRUE;
								else MFlag.B.BLE_ConnectState = FALSE;

								if(BLE_StatusEvent.b.PramUpdataPeer) MFlag.B.BLE_ReadCnntIntv = TRUE;

								break;
							case BCI_CONN_INTV:
							case BCI_CONN_INTV1:
								if((evtpkg->flag & EVTS_CODE_MASK) == EVTS_SUCCESS)
								{
									ConnectIntervalTime = (evtpkg->param[1] << 8) + evtpkg->param[0];
									ConnectIntervalTime = (u16)((float)ConnectIntervalTime * 1.25 + 0.5);
									lcm_printf(6,0,DSP_NORMAL,LCM_FONT8X8,"CnT=%d",ConnectIntervalTime);
								}
								break;
							case BCI_TEST_CTRL:
								BLESleepMode = FALSE;
								MFlag.B.BLE_WaitEventRsp = FALSE;
								break;
						}
						free(evtpkg);
					}
					// profile message or event response
					else
					{
						switch(evtpkg->flag & BCI_ServiceCmdMask)
						{
							case BCI_ServiceMessage:
								if((evtpkg->flag & EVTS_CODE_MASK) == EVTS_SUCCESS)
								{
									if(evtpkg->length > 3)
									{
										//read event response OK or host write event
										MessageEvent = evtpkg;
									}
									else
									{
										//write event response OK
										free(evtpkg);
									}
								}
								else
								{
									//event response error
									free(evtpkg);
								}
								break;
							case BCI_ServiceSupported:
								if((evtpkg->flag & EVTS_CODE_MASK) == EVTS_SUCCESS)
								{
									//read supported uuid event response
								}
								else
								{
									//event response error
								}
								free(evtpkg);
								break;
							case BCI_ServiceProperties:
								if(!ServicePropertiesProcess(&ServiceProperties,evtpkg))
								{
									//event response error
								}
								free(evtpkg);
								break;
						}
					}
				}
				if( BLE_EventRspTOCnt == EVENT_RSP_ERR_MAX)
				{
					//BLE to Power On Reset
					BLE_ParameterInitial();
					//release malloc memory
					while(!IS_TXMQUEUE_EMPTY())
					{
						free(TxMsgQueue[uTxMsgQueueR]);
						if(++uTxMsgQueueR >= MESS_QUEUE_MAX) uTxMsgQueueR = 0;
					}
					MFlag.B.BLE_PwrOnDisplay = FALSE;
					MFlag.B.BLE_ConnectState = FALSE;
					BLE_EventRspTOCnt = 0;
				}
			}

			if(MFlag.B.BLE_ConnectState)
			{
				if(!MFlag.B.BLE_ConnectDisplay)
				{
					lcm_put8x8_string((s8 *)"BLE Connet: Yes ",1,0,DSP_NORMAL);
#if (_CHG_CNNT_INTV_ENABLE_ == 1)
					// min interval=50ms(50ms/1.25ms=40), max interval=100ms(100ms/1.25ms=80)
					TxMessageQueueJoin(BC7701_ConnectIntervalModify(BCI_CONN_INTV1,(_CHG_CNNT_INTV_VALUE_/1.25),(_CHG_CNNT_INTV_VALUE_/1.25)));
//#else
//					MFlag.B.BLE_ReadCnntIntv = TRUE;
#endif
					MFlag.B.BLE_ConnectDisplay = TRUE;
				}
				if(MFlag.B.BLE_ReadCnntIntv)
				{
//					TxMessageQueueJoin(BC7701_SendBCIReadPackage(BCI_CONN_INTV,0x00));
					TxMessageQueueJoin(BC7701_SendBCIReadPackage(BCI_CONN_INTV1,0x00));
					MFlag.B.BLE_ReadCnntIntv = FALSE;
				}

				if(MessageEvent != NULL)
				{
					switch(MessageEvent->opcode)
					{
						case WithoutResponseFFF2:
							if((MessageEvent->length == 4+3) &&
								(MessageEvent->param[0] == 0xB0) )
							{
								Hmessage.type = MessageEvent->param[0];
								Hmessage.key = MessageEvent->param[1];
								Hmessage.serial = MessageEvent->param[2];
								Hmessage.checksum = MessageEvent->param[3];
								LEDStatusUpdate = TRUE;
							}
							free(MessageEvent);
							MessageEvent = NULL;
							break;
					}
				}

				if(MFlag.B.ButtonChange)
				{
					key_status = BTN_GetButtonStatus();
					if(ServiceProperties.b.uwsFFF1)
					{
						Dmessage.type = (Dmessage.key ^ key_status) & 0x0F;
						if( (Dmessage.type != 0) && !IS_TXMQUEUE_FULL(1))
						{
							Dmessage.type = 0xB1;
							Dmessage.key  <<= 4;
							Dmessage.key  |= key_status & 0x0F;
							Dmessage.serial ++;
							Dmessage.checksum =  Dmessage.type ^ Dmessage.key ^ Dmessage.serial;
							TxMessageQueueJoin(UWS_SendNotifyFFF1Data(sizeof(tKEY_MESSAGE),(u8 *)&Dmessage));
						}
					}
					MFlag.B.ButtonChange = FALSE;
				}
			}
			else
			{
				if(MFlag.B.BLE_ConnectDisplay)
				{
					lcm_put8x8_string((s8 *)"BLE Connet: No  ",1,0,DSP_NORMAL);
					lcm_put8x8_clearing(6);
					MFlag.B.BLE_ConnectDisplay = FALSE;
				}
			}

			if(LEDStatusUpdate)
			{
				if(Hmessage.key & 0x01)
				{
					lcm_put8x8_string((s8 *)"Host KEY 1: Dn  ",2,0,DSP_NORMAL);
					LED_always_on(LED1);
				}
				else
				{
					lcm_put8x8_string((s8 *)"Host KEY 1: Up  ",2,0,DSP_NORMAL);
					LED_always_off(LED1);
				}

				if(Hmessage.key & 0x02)
				{
					LED_always_on(LED2);
					lcm_put8x8_string((s8 *)"Host KEY 2: Dn  ",3,0,DSP_NORMAL);
				}
				else
				{
					lcm_put8x8_string((s8 *)"Host KEY 2: Up  ",3,0,DSP_NORMAL);
					LED_always_off(LED2);
				}

				if(Hmessage.key & 0x04)
				{
					LED_always_on(LED3);
					lcm_put8x8_string((s8 *)"Host KEY 3: Dn  ",4,0,DSP_NORMAL);
				}
				else
				{
					lcm_put8x8_string((s8 *)"Host KEY 3: Up  ",4,0,DSP_NORMAL);
					LED_always_off(LED3);
				}
				LEDStatusUpdate = FALSE;
			}
			
#if (_MCU_SLEEP_ENABLE_	== 1)			
			if( (MFlag.B.BLE_WakeUpSignal || !IS_TXMQUEUE_EMPTY()) && !MFlag.B.BLE_WaitEventRsp)
#else
			if( !IS_TXMQUEUE_EMPTY() && !MFlag.B.BLE_WaitEventRsp)
#endif			
			{
				if(BLESleepMode == TRUE)
				{
#if (_MCU_SLEEP_ENABLE_	== 1)								
					MFlag.B.MCU_EnterSleep = FALSE;
#endif					
					if(!MFlag.B.BLE_WakeUpDelay)
					{
						if(BC7701_DummyWakeup())
						{
							BLEWakeUpDlyTm = 4;				//BLE wake up delay 4ms
							MFlag.B.BLE_WakeUpDelay = TRUE;
						}
					}
					else
					{
						//BLE to normal mode and check BLE wake up finish
						if(BLEWakeUpDlyTm == 0)
						{
							evtpkg=BC7701_SendBCIReadPackage(BCI_TEST_CTRL,00);
							if(evtpkg != NULL)
							{
								if(BLE_Transceive(evtpkg,50) == TRUE)
								{
									MFlag.B.BLE_WaitEventRsp = TRUE;
									MFlag.B.BLE_WakeUpDelay = FALSE;
#if( _MCU_SLEEP_ENABLE_	== 1)
									if(MFlag.B.BLE_WakeUpSignal) BLESleepDlyTm = _SLEEP_DELAY_TIMER_; 
									MFlag.B.BLE_WakeUpSignal = FALSE;
#endif									
								}
								else free(evtpkg);
							}
						}
					}
				}
				else
				{
					if(BLE_Transceive(TxMsgQueue[uTxMsgQueueR],EVENT_RETURN_TIME) == TRUE)
					{
						if(++uTxMsgQueueR >= MESS_QUEUE_MAX) uTxMsgQueueR = 0;
					}
				}
			}
			
			
			//BLE to Deep Sleep Mode
			if(!BLESleepMode && IS_TXMQUEUE_EMPTY() && !MFlag.B.BLE_WaitEventRsp)
			{
#if (_MCU_SLEEP_ENABLE_ == 0)
				if(BC7701_ReadTransmitEmpty() && BC7701_ReadReceiveEmpty() && BLE_EventResponseEmpty() )
				{
					if(BLESleepDlyTm == 0)
					{
						evtpkg = BC7701_SetOperateMode(OP_DEEPSLEEP,DISABLE,_MASTER_WUW_VALUE_,_MASTER_WUT_VALUE_);
						if(evtpkg != NULL)
						{
							if(BLE_Transceive(evtpkg,EVENT_RETURN_TIME/2) == TRUE)
							{
								MFlag.B.BLE_WaitEventRsp = TRUE;
							}
							else free(evtpkg);
						}
					}
				}
#else
				key_status = BTN_GetButtonStatus();				
				if((key_status == 0) &&	BC7701_ReadTransmitEmpty() && 
					BC7701_ReadReceiveEmpty() && BLE_EventResponseEmpty() )
				{
					if(BLESleepDlyTm == 0)
					{
						evtpkg = BC7701_SetOperateMode(OP_DEEPSLEEP,ENABLE,_MASTER_WUW_VALUE_,_MASTER_WUT_VALUE_);
						if(evtpkg != NULL)
						{
							if(BLE_Transceive(evtpkg,EVENT_RETURN_TIME/2) == TRUE)
							{
								MFlag.B.BLE_WaitEventRsp = TRUE;
							}
							else free(evtpkg);
						}
					}
				}	
#endif				
				else
				{
					BLESleepDlyTm = _SLEEP_DELAY_TIMER_;
				}
			}			
		}
		if(BLE_Operate.States == _BLE_PWR_ON_ERROR_)
		{
			if(!MFlag.B.BLE_PwrOnDisplay)
			{
				lcm_put8x8_string((s8 *)"BLE PwrOn : Fail",0,0,DSP_NORMAL);
				MFlag.B.BLE_PwrOnDisplay = TRUE;
			}
		}
#if (_MCU_SLEEP_ENABLE_	== 1)
		if(MFlag.B.MCU_EnterSleep)
		{
			MFlag.B.MCU_EnterSleep = FALSE;
			MCU_SleepModeProcess();
			MFlag.B.BLE_WakeUpSignal = TRUE;
		}
#endif		
   }
}

#if (_MCU_SLEEP_ENABLE_ == 1)
/*****************************************************************************************************
* @brief  Configures the system clocks.
* @retval None
*******************************************************************************************************/
void MCU_SleepModeProcess(void)
{
	EXTI_InitTypeDef EXTI_InitStruct = {0};
#if	(MDEBIO_ENABLE == 1)	
	MDBIO_P0_SET();
#endif	
	/* UART_RXD to GPIO mode */	
	AFIO_GPxConfig(UART_RXD_AFIO_PORT, UART_RXD, AFIO_FUN_GPIO);
	GPIO_DirectionConfig(UART_RXD_PORT,UART_RXD,GPIO_DIR_IN);
   GPIO_InputConfig(UART_RXD_PORT,UART_RXD,ENABLE);	
	AFIO_EXTISourceConfig(UART_WAKEUP_EXIT_CH, UART_WAKEUP_ESS_PORT);	
	EXTI_InitStruct.EXTI_Channel = UART_WAKEUP_EXIT_CH;
	EXTI_InitStruct.EXTI_IntType = EXTI_NEGATIVE_EDGE;
	EXTI_InitStruct.EXTI_Debounce = EXTI_DEBOUNCE_DISABLE;
	EXTI_InitStruct.EXTI_DebounceCnt = 00;
	EXTI_Init(&EXTI_InitStruct);	
	BTN_WakeupConfig(ENABLE);
	EXTI_WakeupEventConfig(UART_WAKEUP_EXIT_CH,EXTI_WAKEUP_LOW_LEVEL, ENABLE);
	BTN_ClearWakeupFlag();
	EXTI_ClearWakeupFlag(UART_WAKEUP_EXIT_CH);
	PWRCU_DeepSleep1(PWRCU_SLEEP_ENTRY_WFE);
	/* UART_RXD to UART mode */	
	AFIO_GPxConfig(UART_RXD_AFIO_PORT, UART_RXD, UART_RXD_AFIO_FUN);
	BTN_ClearWakeupFlag();
	EXTI_ClearWakeupFlag(UART_WAKEUP_EXIT_CH);
#if	(MDEBIO_ENABLE == 1)		
	MDBIO_P0_CLR();
#endif	
}
#endif
/*****************************************************************************************************
* @brief  Configures the system clocks.
* @retval None
*******************************************************************************************************/
void MCU_gpio_Configuration(void)
{
#if	(MDEBIO_ENABLE == 1)
	AFIO_GPxConfig(MDBIO_P0_AFIO_PORT, MDBIO_P0, MDBIO_P0_AFIO_FUN);
	AFIO_GPxConfig(MDBIO_P1_AFIO_PORT, MDBIO_P1, MDBIO_P1_AFIO_FUN);

	GPIO_DirectionConfig(MDBIO_P0_PORT,MDBIO_P0,GPIO_DIR_OUT);
	MDBIO_P0_CLR();
	GPIO_DirectionConfig(MDBIO_P1_PORT,MDBIO_P1,GPIO_DIR_OUT);
	MDBIO_P1_CLR();
#endif
	
	AFIO_GPxConfig(GPIO_PA, GPIO_PIN_0 | GPIO_PIN_1, AFIO_FUN_GPIO);
	GPIO_DirectionConfig(HT_GPIOA,GPIO_PIN_0 | GPIO_PIN_1,GPIO_DIR_IN);
   GPIO_InputConfig(HT_GPIOA,GPIO_PIN_0 | GPIO_PIN_1,ENABLE);	
}
/*******************************************************************************************************
 * @brief  Configures the system clocks.
 * @retval None
 *******************************************************************************************************/
/*
//  <h> Clock Control Configuration
//  	<h> Communication
//    	<q0.12> EBI
//    	<q1.0> I2C0		<q1.1> I2C1
//    	<q1.25> I2S
//    	<q1.24> SCI0	<q1.27> SCI1
//    	<q1.4> SPI0 	<q1.5> SPI1
//    	<q1.8> USART0	<q1.9> USART1
//    	<q1.10> UART0  <q1.11> UART1
//    	<q0.10>  USB
//  	</h>
//  	<h> IO
//    	<q0.16> GPIO Port A <q0.17>  GPIO Port B <q0.18>  GPIO Port C <q0.19>  GPIO Port D
//    	<q1.14> AFIO
//    	<q1.15> EXTI
//  	</h>
//  	<h> System
//    	<q2.24> ADC
//    	<q0.11> CKREF
//    	<q0.13>  CRC
//    	<q2.22> CMP
//    	<q0.4>  PDMA
//    	<q2.6> PWRCU
//  	</h>
//  	<h> Timer
//    	<q2.16> BFTM0 <q2.17> BFTM1
//    	<q2.28> SCTM0 <q2.29> SCTM1 <q2.30> SCTM2 <q2.31> SCTM3
//    	<q2.8> GPTM0 <q2.9> GPTM1
//    	<q2.0> MCTM0
//    	<q2.6> RTC   <q2.4> WDT
//  	</h>
//  </h>
*/
#define	_CKCU_AHBCCR_		(0x000F0800)
#define	_CKCU_APBCR0_		(0x0000CF33)
#define	_CKCU_APBCR1_		(0x10030000)

void CKCU_Configuration(void)
{
	CKCU_PeripClockConfig_TypeDef cken;

   /* APB Peripheral Clock Selection to CK_AHB or CK_AHB/4 */
   HT_CKCU->APBPCSR0 = 0;           /* Reset value of APBPCSR0   */
   HT_CKCU->APBPCSR1 = 0;           /* Reset value of APBPCSR1   */

   /* Configure the CK_ADC prescaler(CK_ADC) = HCLK / 1 */
   CKCU_SetADCPrescaler(CKCU_ADCPRE_DIV1);
	/* Configure the AHB/APB clock control */
	cken.Reg[0] = _CKCU_AHBCCR_;
	cken.Reg[1] = _CKCU_APBCR0_;
	cken.Reg[2] = _CKCU_APBCR1_;
   CKCU_PeripClockConfig(cken,ENABLE);
}
